﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="System.Diagnostics" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
<script runat="server">

    public class Params: ContextBase {
    
        public Params(Context context): base(context) {
            Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
            okres = new YearMonth(data).ToFromTo();
        }
    
        FromTo okres;
        [Required]
        [Caption("Raport za okres")]
        [Priority(1)]
        public FromTo Okres {
            get { return okres; }
            set {
                okres = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool wydziały = true;
        [Priority(2)]
        public bool Wydziały {
            get { return wydziały; }
            set {
                wydziały = value;
                OnChanged(EventArgs.Empty);
            }
        }
    
        bool pomińZerowe = true;
        [Priority(3)]
        public bool PomińZerowe {
            get { return pomińZerowe; }
            set {
                pomińZerowe = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }
    
    Params pars;
    [Context]
    public Params Pars {
        get { return pars; }
        set { pars = value; }
    }

    public class SrParams : SerializableContextBase {
        public SrParams(Context context) : base(context) {
        }

        bool pelneStanowisko = false;
        [Priority(1)]
        [Caption("Stanowisko pełna nazwa")]
        public bool PelneStanowisko {
            get { return pelneStanowisko; }
            set {
                pelneStanowisko = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    SrParams srpars;
    [SettingsContext]
    public SrParams SrPars {
        get { return srpars; }
        set { srpars = value; }
    }		
    
    class Total: IComparable {
    
        readonly Wydzial wydzial;
        readonly FromTo okres;
        readonly ArrayList pracownicy = new ArrayList();
    
        public Total(Wydzial wydzial, FromTo okres) {
            this.wydzial = wydzial;
            this.okres = okres;
        }
    
        public Wydzial Wydzial {
            get { return wydzial; }
        }
    
        public FromTo Okres {
            get { return okres; }
        }
    
        public ArrayList Lista {
            get { return pracownicy; }
        }
    
        public int CompareTo(object obj) {
            if (obj==null)
                return 1;
            return wydzial.Nazwa.CompareTo(((Total)obj).Wydzial.Nazwa);
        }
    }
    
    void OnContextLoad(Object sender, EventArgs e) {
        Row[] rows = (Row[])dc[typeof(Row[])];
        Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
        Hashtable ht = new Hashtable();
        Wydzial firma = KadryModule.GetInstance(dc).Wydzialy.Firma;
    
        foreach (Pracownik idx in rows) {
            PracHistoria ph = idx[data];
            Wydzial w = ph.Etat.Wydzial;
            if (w != null) {
                if (!pars.Wydziały)
                    w = firma;
                Total t = (Total)ht[w];
                if (t == null) {
                    t = new Total(w, pars.Okres);
                    ht.Add(w, t);
                }
                t.Lista.Add(ph);
            }
        }
    
        ArrayList totals = new ArrayList(ht.Values);
        totals.Sort();
        DataRepeater1.DataSource = totals;
    }
    
    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        PracHistoria ph = (PracHistoria)args.Row;
        colStanowisko.EditValue = GetStanowisko(ph);
        KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik, null);
        double[] d = new double[10];
        double sd = 0;
        foreach (OkresNieobecności n in kalk.Nieobecnosci(pars.Okres, true)) {
            double i = 0;
            if (n.Definicja.Typ == TypNieobecnosci.NieobecnośćZUS)
                i = n.Okres.Days;
            else {
                Time t1 = kalk.Plan.Norma(n.Okres).Czas;
                Time t2 = n.Norma().Czas;
                if (t1 != Time.Zero) {
                    if (n.Okres.Days == 1)
                        i = System.Math.Round((t2 / t1), 4);
                    else
                        i = System.Math.Round((t2 / t1) * n.Norma().Dni, 4);
                }
            }
            if (i > 0) {
                sd += i;
                switch (n.Definicja.Przyczyna) {
                    case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
                        d[0] += i; break;
                    case PrzyczynaNieobecnosci.UrlopBezpłatny:
                        d[1] += i; break;
                    case PrzyczynaNieobecnosci.UrlopOkolicznościowy:
                        d[4] += i; break;
                    case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
                        d[5] += i; break;
                    case PrzyczynaNieobecnosci.UrlopMacierzyński:
                        d[6] += i; break;
                    case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
                        d[7] += i; break;
                    case PrzyczynaNieobecnosci.UrlopWychowawczy:
                        d[8] += i; break;
                    default:
                        switch (n.Definicja.Guid.ToString()) {
                            case "00000000-0006-0005-0020-000000000000": //"Urlop szkoleniowy"
                                d[2] += i; break;
                            case "00000000-0006-0005-0012-000000000000": //"Urlop opiekuńczy (art 188 kp, dni)"
                            case "00000000-0006-0005-0046-000000000000": //"Urlop opiekuńczy (art 188 kp, godz.)"
                                d[3] += i; break;
                            default:
                                d[9] += i; break;
                        }
                        break;
                }
            }
        }
    
        if (sd==0 && pars.PomińZerowe)
            args.VisibleRow = false;
        else {
            wypoczynkowy.EditValue = d[0];
            bezplatny.EditValue = d[1];
            szkoleniowy.EditValue = d[2];
            opieka.EditValue = d[3];
            okolicz.EditValue = d[4];
            zwollek.EditValue = d[5];
            zmacierz.EditValue = d[6];
            zopiek.EditValue = d[7];
            wychow.EditValue = d[8];
            inne.EditValue = d[9];
            razem.EditValue = sd;
        }
    }

    string GetStanowisko(PracHistoria ph) {
        string stanowiskoPelne = "";
        if (srpars.PelneStanowisko)
            stanowiskoPelne = ph.Etat.StanowiskoPełne;
        if (stanowiskoPelne.Length == 0)
            stanowiskoPelne = ph.Etat.Stanowisko;
        return stanowiskoPelne;
    }
    
    protected void DataRepeater1_BeforeRow(object sender, EventArgs e) {
        Total t = (Total)DataRepeater1.CurrentRow;

        ReportHeader1.Title = "ZESTAWIENIE NIEOBECNOŚCI|</strong>Za okres:<strong> "
            + t.Okres.ToString()
            + "|</strong>Dla wydziału:<strong> "
            + t.Wydzial.Nazwa + " (" + t.Wydzial.Kod + ")";
    }

    static void Msg(object value) {
    }

</script>
<title>Ewidencja czasu pracy</title> 
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form id="EwidencjaCzasuPracy" method="post" runat="server">
        <ea:datacontext id="dc" runat="server" Landscape="True" oncontextload="OnContextLoad" TypeName="Soneta.Business.Row[], Soneta.Business"></ea:datacontext>
        <ea:DataRepeater id="DataRepeater1" runat="server" Height="165px" Width="744px" 
            onbeforerow="DataRepeater1_BeforeRow">
            <ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False"></ea:PageBreak>
            <cc1:reportheader NagłówekOddziału="NagłówekOddziału" id="ReportHeader1" runat="server"></cc1:reportheader>
            <ea:grid id="Grid1" runat="server" RowTypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" DataMember="Lista" OnBeforeRow="Grid1_BeforeRow">
                <Columns>
                    <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp."></ea:GridColumn>
                    <ea:GridColumn Width="25" Align="Left" DataMember="Pracownik.NazwiskoImię" EncodeHTML="true" Caption="Nazwisko i imię"></ea:GridColumn>
                    <ea:GridColumn Width="20" ID="colStanowisko" EncodeHTML="true" Caption="Stanowisko"></ea:GridColumn>
                    <ea:GridColumn Width="10" Align="Center" DataMember="Etat.OkresZatrudnienia.From" Total="Info" EncodeHTML="true" Caption="Data zatrudnienia"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop wypocz." HideZero="True" ID="wypoczynkowy"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop bezpłatny" HideZero="True" ID="bezplatny"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop szkoleniowy" HideZero="True" ID="szkoleniowy"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop opieka (art. 188 kp) " HideZero="True" ID="opieka"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop okoliczność." HideZero="True" ID="okolicz"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Zwol. lek." HideZero="True" ID="zwollek"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop macierz." HideZero="True" ID="zmacierz"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Opieka ZUS" HideZero="True" ID="zopiek"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Urlop wychow." HideZero="True" ID="wychow"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Inne nieobecn." HideZero="True" ID="inne"></ea:GridColumn>
                    <ea:GridColumn Align="Center" Total="Sum" EncodeHTML="true" Caption="Razem" ID="razem"></ea:GridColumn>
                </Columns>
            </ea:grid>
            <cc1:reportfooter id="ReportFooter1" runat="server" TheEnd="False"></cc1:reportfooter>
        </ea:DataRepeater>
    </form>
</body>
</html>
